<?php

namespace Database\Seeders;

use App\Models\Currency;
use Illuminate\Database\Seeder;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $currencies = config('seeder.currencies');

        foreach ($currencies as $key => $data) {
            Currency::factory()->create([
               "designation" => $data["designation"],
               "code" => config($data["code"]),
            ]);
        }
    }
}
