<?php

namespace Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Seeder;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countries = config('torryme.countries');

        foreach ($countries as $key => $data) {
             Country::factory()->create([
                'dial_code' => $data['dial_code'],
                'designation' => $data['designation'],
                'country_code' => $data['country_code'],
            ]);

        }
    }
}
