<?php

namespace Database\Seeders;

use App\Models\Attribute;
use App\Models\AttributeSiUnit;
use App\Models\AttributeValue;
use App\Models\BusinessCategory;
use App\Models\BusinessCategoryAttribute;
use App\Models\BusinessSubCategory;
use App\Models\BusinessSubCategoryChild;
use Illuminate\Database\Seeder;

class BusinessCategorySeeder extends Seeder
{
   /**
    * Run the database seeds.
    */
   public function run(): void
   {
      $businessCategories = config('seeder.business_categories');

      foreach ($businessCategories as $key => $data) {
         $businessCategoryExist = BusinessCategory::findByCode(config($data["code"]));

         if ($businessCategoryExist === null) {
            $businessCategory = BusinessCategory::factory()->create([
               "designation" => $data["designation"],
               "code" => config($data["code"]),
               "description" => $data["description"],
               "disabled_at" => null,
            ]);

            foreach ($data["base_attributes"] as $baseAttribute) {
               $attribute = Attribute::factory()->create([
                  "designation" => $baseAttribute["designation"],
                  "type" => $baseAttribute["type"],
                  "business_id" => $baseAttribute["business_id"],
               ]);

               foreach ($baseAttribute["attribute_si_units"] as $attributeSiUnits) {
                  $attributeSiUnit = AttributeSiUnit::factory()->create([
                     "si_unit" => $attributeSiUnits["si_unit"],
                     "si_unit_designation" => $attributeSiUnits["si_unit_designation"],
                     "attribute_id" => $attribute->{"id"},
                  ]);

                  AttributeValue::factory()->create([
                     "attribute_id" => $attribute->{"id"},
                     "attribute_si_unit_id" => $attributeSiUnit->{"id"},
                  ]);
               }

               BusinessCategoryAttribute::factory()->create([
                  "attribute_id" => $attribute->{"id"},
                  "business_category_id" => $businessCategory->{"id"},
               ]);
            }

            foreach ($data["sub_categories"] as $subCategory) {
               $businessSubCategory = BusinessSubCategory::factory()->create([
                  "designation" => $subCategory["designation"],
                  "code" => config($subCategory["code"]),
                  "description" => $subCategory["description"],
                  "business_category_id" => $businessCategory->{"id"},
               ]);

               foreach ($subCategory["child_sub_categories"] as $childSubCategory) {
                  $businessSubCategoryChild = BusinessSubCategoryChild::factory()->create([
                     "designation" => $childSubCategory["designation"],
                     "code" => $childSubCategory["code"] !== null ? config($childSubCategory["code"]) : $childSubCategory["code"],
                     "business_sub_category_id" => $businessSubCategory->{"id"},
                  ]);

                  foreach ($childSubCategory["grand_child_sub_categories"] as $grandChildSubCategory) {
                     BusinessSubCategoryChild::factory()->create([
                        "designation" => $grandChildSubCategory["designation"],
                        "business_sub_category_id" => $businessSubCategory->{"id"},
                        "parent_id" => $businessSubCategoryChild->{"id"},
                     ]);
                  }
               }
            }
         }
      }
   }
}
