<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('realtime_message_attachments', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->text('path');
         $table->text('original_name');
         $table->string('attachment_type'); // Use AttachmentTypeEnum
         $table->string('uuid');

         $table
            ->foreignId('realtime_message_id')
            ->constrained('realtime_messages')
            ->onUpdate('cascade')
            ->onDelete('cascade');

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
         $table->softDeletes();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('realtime_message_attachments');
   }
};
