<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dispute_messages', function (Blueprint $table) {
           $table->bigIncrements('id');

           $table->longText('message');
           $table->string('uuid')->unique();
           $table->timestamp('sent_at');

           $table
              ->foreignId('dispute_id')
              ->constrained('disputes')
              ->onUpdate('cascade')
              ->onDelete('cascade');
           $table
              ->foreignId('emitter_participant_id')
              ->constrained('dispute_participants')
              ->onUpdate('cascade')
              ->onDelete('cascade');
           $table
              ->foreignId('respond_to_message_id')
              ->nullable()
              ->constrained('dispute_messages')
              ->onUpdate('cascade')
              ->onDelete('cascade');

           $table->timestamp('created_at')->useCurrent();
           $table->timestamp('updated_at')->useCurrent();
           $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dispute_messages');
    }
};
