<?php

use App\Enums\DisputeStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('disputes', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->string('uuid')->unique();
         $table->string('name');
         $table->string('label_color');
         $table->string('status')->default(DisputeStatusEnum::onGoing);

         $table
            ->foreignId('dispute_type_id')
            ->constrained('dispute_types')
            ->onUpdate('cascade')
            ->onDelete('cascade');
         $table
            ->foreignId('transaction_id')
            ->constrained('transactions')
            ->onUpdate('cascade')
            ->onDelete('cascade');
         $table
            ->foreignId('created_by_id')
            ->constrained('users')
            ->onUpdate('cascade')
            ->onDelete('cascade');

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
         $table->softDeletes();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('disputes');
   }
};
