<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('dispute_types', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->string('code')->unique();
         $table->string('designation');

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
         $table->softDeletes();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('dispute_types');
   }
};
