<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('realtime_messages', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->longText('message');
         $table->string('uuid')->unique();
         $table->timestamp('sent_at');

         $table
            ->foreignId('chat_id')
            ->constrained('chats')
            ->onUpdate('cascade')
            ->onDelete('cascade');
         $table
            ->foreignId('emitter_participant_id')
            ->constrained('realtime_participants')
            ->onUpdate('cascade')
            ->onDelete('cascade');
         $table
            ->foreignId('receiver_participant_id')
            ->nullable()
            ->constrained('realtime_participants')
            ->onUpdate('cascade')
            ->onDelete('cascade');
         $table
            ->foreignId('respond_to_message_id')
            ->nullable()
            ->constrained('realtime_messages')
            ->onUpdate('cascade')
            ->onDelete('cascade');

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
         $table->softDeletes();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('realtime_messages');
   }
};
