<?php

use App\Enums\AccountPrivacyEnum;
use App\Enums\GenericStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_privacy_settings', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('enable_privacy')->default(GenericStatusEnum::enable->value);

            $table->string('enable_2factor_auth')->default(GenericStatusEnum::disable->value);
            $table->string('who_can_comment')->default(AccountPrivacyEnum::everyOne->value);
            $table->string('who_can_mention')->default(AccountPrivacyEnum::everyOne->value);
            $table->string('who_can_see_follower_list')->default(AccountPrivacyEnum::everyOne->value);
            $table->string('who_can_invite_you_by_direct_message')->default(AccountPrivacyEnum::everyOne->value);
            $table->string('who_can_invite_you_into_community')->default(AccountPrivacyEnum::everyOne->value);
            $table->string('who_can_download_post')->default(AccountPrivacyEnum::everyOne->value);

            $table
                ->foreignId('user_id')
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_privacy_settings');
    }
};
