<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('user_emails', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->string('email');
         $table->timestamp('verified_at')->nullable();
         $table
            ->foreignId('user_id')
            ->constrained('users')
            ->onUpdate('cascade')
            ->onDelete('cascade');

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('user_emails');
   }
};
