<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('user_telephones', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->string('telephone')->unique();
         $table->string('type');
         $table->timestamp('deactivated_at')->nullable();
         $table->timestamp('verified_at')->nullable();
         $table
            ->foreignId('user_id')
            ->constrained('users')
            ->onUpdate('cascade')
            ->onDelete('cascade');

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('user_telephones');
   }
};
