<?php

use App\Enums\OrderStatusEnum;
use App\Enums\OrderTypesEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->float('total_customer_amount',12,2);
            $table->float('total_customer_amount_after_coupon',12,2)->default(0);
            $table->float('total_supplier_amount',12,2);
            $table->float('total_supplier_amount_after_coupon',12,2)->default(0);
            $table->string('type')->default(OrderTypesEnum::simple->value);
            $table->string('status')->default(OrderStatusEnum::pending->value);
            $table->float('customer_shipping_amount',12,2)->nullable();
            $table->float('supplier_shipping_amount',12,2)->nullable();
            $table->dateTime('delivery_date')->nullable();
            $table->dateTime('received_at')->nullable();
            $table->dateTime('delivered_at')->nullable();
            $table->dateTime('cancelled_at')->nullable();
            $table->text('reason_for_cancellation')->nullable();

            $table
                ->foreignId('coupon_id')
                ->nullable()
                ->constrained('coupons')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('customer_user_id')
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('supplier_business_id')
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('customer_currency_id')
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('supplier_currency_id')
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('customer_shipping_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('supplier_shipping_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('cancelled_by_user_id')
                ->nullable()
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');


            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
