<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cart_item_attributes', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table
                ->foreignId('cart_item_id')
                ->constrained('cart_items')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('product_attribute_id')
                ->constrained('product_attributes')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cart_item_attributes');
    }
};
