<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('designation');
            $table->string('code')->default(config('torryme.constants.default_coupon_code'));
            $table->string('description')->nullable();
            $table->string('discount_type');
            $table->float('percentage_discount')->nullable();
            $table->float('fixed_card_discount_amount')->nullable();
            $table->dateTime('product_discount_start_date')->nullable();
            $table->dateTime('expiring_date');
            $table->float('minimum_amount_to_spend', 12,1)->nullable();
            $table->float('maximum_amount_to_spend', 12,1)->nullable();

            $table
                ->foreignId('product_id')
                ->nullable()
                ->constrained('products')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_id')
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('fixed_card_discount_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('minimum_amount_to_spend_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('maximum_amount_to_spend_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
