<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('business_category_attributes', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table
                ->foreignId('attribute_id')
                ->constrained('attributes')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_category_id')
                ->constrained('business_categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('business_category_attributes');
    }
};
