<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('percentage_transaction_fees', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->float('percentage', 12, 3);

            $table
                ->foreignId('business_id')
                ->nullable()
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_category_id')
                ->nullable()
                ->constrained('business_categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('country_id')
                ->nullable()
                ->constrained('countries')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('percentage_transaction_fees');
    }
};
