<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pending_payments', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->float('amount', 12, 2);
            $table->float('buyer_amount', 12, 2);

            $table
                ->foreignId('seller_wallet_id')
                ->constrained('wallets')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('seller_currency_id')
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('buyer_wallet_id')
                ->constrained('wallets')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('buyer_currency_id')
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->float('platform_fees', 12, 2);
            $table
                ->foreignId('platform_currency_id')
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('validity')->nullable();
            $table->timestamp('delivered_at')->nullable();
            $table->timestamp('validated_at')->nullable();
            $table->timestamp('refunded_at')->nullable();
            $table->timestamp('suspended_at')->nullable();

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pending_payments');
    }
};
