<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('communities', function (Blueprint $table) {
           $table->bigIncrements('id');

           $table->string('designation');
           $table->longText('description');
           $table->string('uuid')->unique();
           $table->string('avatar')->nullable();
           $table->string('label_color')->nullable();
           $table->string('visibility');

           $table
              ->foreignId('create_by_user_id')
              ->constrained('users')
              ->onUpdate('cascade')
              ->onDelete('cascade');

           $table->timestamp('created_at')->useCurrent();
           $table->timestamp('updated_at')->useCurrent();
           $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('communities');
    }
};
