<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_attributes', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('value')->nullable();
            $table->string('extra_value')->nullable();
            $table->float('additional_price', 12,2)->nullable();

            $table->foreignId('additional_price_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('product_id')
                ->constrained('products')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('attribute_id')
                ->nullable()
                ->constrained('attributes')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('attribute_value_id')
                ->nullable()
                ->constrained('attribute_values')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_attributes');
    }
};
