<?php

use App\Enums\ProductStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('designation');
            $table->longText('description');
            $table->integer('quantity')->nullable();
            $table->integer('unit')->nullable();
            $table->float('price',12,2);
            $table->bigInteger('min_order')->default(1);
            $table->bigInteger('max_order')->default(0);
            $table->integer('delivery_in_days')->nullable();
            $table->timestamp('activated_at')->nullable();
            $table->timestamp('published_at')->nullable();
            $table->string('creation_status')->default(ProductStatusEnum::incomplete->value);

            $table
                ->foreignId('business_id')
                ->constrained('businesses')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_category_id')
                ->constrained('business_categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_sub_category_id')
                ->constrained('business_sub_categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_sub_category_child_id')
                ->constrained('business_sub_category_child')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('business_sub_category_grand_child_id')
                ->nullable()
                ->constrained('business_sub_category_child')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('price_currency_id')
                ->nullable()
                ->constrained('currencies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('movie_id')
                ->nullable()
                ->constrained('movies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->foreignId('series_id')
                ->nullable()
                ->constrained('series')
                ->onUpdate('cascade')
                ->onDelete('cascade');
           $table->foreignId('music_id')
              ->nullable()
              ->constrained('music')
              ->onUpdate('cascade')
              ->onDelete('cascade');
            $table->foreignId('music_album_id')
                ->nullable()
                ->constrained('music_albums')
                ->onUpdate('cascade')
                ->onDelete('cascade');
           $table->foreignId('book_id')
              ->nullable()
              ->constrained('books')
              ->onUpdate('cascade')
              ->onDelete('cascade');
            $table->foreignId('game_id')
                ->nullable()
                ->constrained('games')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
