<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('music', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('designation')->nullable();
            $table->longText('description')->nullable();
            $table->string('file_path')->nullable();
            $table->string('cover')->nullable();
            $table->integer('occurrence');

            $table->foreignId('music_album_id')
                ->nullable()
                ->constrained('music_albums')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('music');
    }
};
