<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('season_episodes', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('designation')->nullable();
            $table->longText('description')->nullable();
            $table->integer('occurrence');
            $table->string('file_path');

            $table->foreignId('series_season_id')
                ->constrained('series_seasons')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('season_episodes');
    }
};
