<?php

use App\Enums\GenericStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('business_category_settings', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('can_affiliate')->default(GenericStatusEnum::disable->value);

            $table
                ->foreignId('business_category_id')
                ->constrained('business_categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('business_category_settings');
    }
};
