<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallet_pin_change_histories', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('old_wallet_pin');
            $table->string('new_wallet_pin');
            $table->string('status'); // Use this enumeration PasswordAndWalletPinChangeStatusEnum

            $table
                ->foreignId('wallet_id')
                ->constrained('wallets')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table
                ->foreignId('user_id')
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_pin_change_histories');
    }
};
