<?php

use App\Enums\ExternalAccountStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('external_accounts', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('telephone')->nullable();
            $table->string('email')->nullable();
            $table->string('card_number')->nullable();
            $table->string('card_pin')->nullable();
            $table->date('card_expiry_date')->nullable();
            $table->string('status')->default(ExternalAccountStatusEnum::active->value);
            $table->string('payment_gateway'); // Use PaymentGateWayEnum
            $table->string('operation_direction'); // Use ExternalAccountDirectionEnum
            $table->string('name');

            $table
                ->foreignId('user_id')
                ->constrained('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('external_accounts');
    }
};
