<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   /**
    * Run the migrations.
    */
   public function up(): void
   {
      Schema::create('user_details', function (Blueprint $table) {
         $table->bigIncrements('id');

         $table->text('first_name');
         $table->text('last_name');
         $table->date('date_of_birth');

         $table->timestamp('created_at')->useCurrent();
         $table->timestamp('updated_at')->useCurrent();
         $table->softDeletes();
      });
   }

   /**
    * Reverse the migrations.
    */
   public function down(): void
   {
      Schema::dropIfExists('user_details');
   }
};
