<?php

namespace App\Services;

use App\Models\WalletPinChangeHistory;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait WalletPinChangeHistoryService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return WalletPinChangeHistory::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Find by wallet id
     *
     * @param int $walletId
     * @return Model|Builder|null
     */
    public static function findByWalletId(int $walletId): Model|Builder|null
    {
        return WalletPinChangeHistory::query()->where("wallet_id", $walletId)->first();
    }

    /**
     * Get last change history
     *
     * @param int $walletId
     * @return Model|Builder|null
     */
    public static function getLastChangeHistory(int $walletId): Model|Builder|null
    {
        return WalletPinChangeHistory::query()->where("wallet_id", $walletId)->latest()->first();
    }
}
