<?php

namespace App\Services;

use App\Models\PostHashTag;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait PostHashTagService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return PostHashTag::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get most used user or business hashtags
     *
     * @return Builder[]|Collection
     */
    public static function mostUsedHashTags(): Collection|array
    {
        /** @var User $user */
        $user = auth()->user();;

        $hashTags =
            PostHashTag::query()
                ->with('hashTag')
                ->whereHas('post', function (Builder $builder) use($user) {
                    $builder
                        ->where('user_id', $user->{'id'})
                        ->orWhere('business_id', $user->{'business'}?->{'id'});
                })
                ->select('hash_tag_id')
                ->selectRaw('COUNT(*) AS occurrences')
                ->groupBy('hash_tag_id')
                ->orderByDesc('occurrences')
                ->limit(10)
                ->get();

        $result = array();
        foreach ($hashTags as $hashTag) {
            $result[] = $hashTag->{"hashTag"}->{"designation"};
        }

        return $result;
    }
}
