<?php

namespace App\Services;

use App\Models\Order;
use App\Models\OrderDetail;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait OrderDetailService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return OrderDetail::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Compute all order details
     *
     * @param Order $order
     * @return array
     */
    public static function computeOrderDetails(Order $order): array
    {
        $result = [];
        $orderDetails = $order->{"orderDetails"};

        foreach ($orderDetails as $orderDetail) {
            $result[] = array(
                "id" => $orderDetail->{"id"},
                "quantity" => $orderDetail->{"quantity"},
                "customer_amount" => $orderDetail->{"customer_amount"},
                "supplier_amount" => $orderDetail->{"supplier_amount"},
                "customer_currency" => $orderDetail->{"customerCurrency"}->{'code'},
                "supplier_currency" => $orderDetail->{"supplierCurrency"}->{'code'},

                "attributes" => $orderDetail->computeAttributeDetails(),
                "product" => $orderDetail->{"product"}->computeDetailsForOrderDetails()
            );
        }

        return $result;
    }

    /**
     * Compute attribute details
     *
     * @return array
     */
    public function computeAttributeDetails(): array
    {
        $result = [];
        $attributes = $this->{'orderDetailAttributes'};

        foreach ($attributes as $attribute) {
            $result[] = $attribute->computeForDetails();
        }

        return $result;
    }
}
