<?php

namespace App\Services;

use App\Models\Country;
use App\Models\Currency;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait CurrencyService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        if(isset($data['code'])) {
            $data['code'] = mb_strtoupper($data['code']);
        }

        return Country::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        if(isset($data['code'])) {
            $data['code'] = mb_strtoupper($data['code']);
        }

        return tap($this)->update($data);
    }

    /**
     * Find by currency code
     *
     * @param ?string $code
     * @return Builder|Model|null
     */
    public static function findByCode(?string $code): Model|Builder|null
    {
        if (! filled($code)) {
            return null;
        }

        return Currency::query()->where('code', mb_strtoupper($code))->first();
    }

    /**
     * All supported currencies
     *
     * @return Builder[]|Collection
     */
    public static function allCurrencies(): Collection|array
    {
        return Currency::query()->get();
    }
}
