<?php

namespace App\Services;

use App\Models\CartItem;
use App\Models\CartItemAttribute;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait CartItemAttributeService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return CartItemAttribute::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Compute cart attribute details
     *
     * @param CartItem $cartItem
     * @return array
     */
    public static function computeForProductCartDetails(CartItem $cartItem): array
    {
        $result = [];
        $cartAttributes = $cartItem->{'cartAttributes'};

        foreach ($cartAttributes as $cartAttribute) {
            $result[] = $cartAttribute->{"cartProductAttribute"}->computeForDetails();
        }

        return $result;
    }
}
