<?php

namespace App\Services;

use App\Models\BusinessSubCategoryChild;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait BusinessSubCategoryChildService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return BusinessSubCategoryChild::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Find by id
     *
     * @param int $id
     * @return Builder|Builder[]|Collection|Model|null
     */
    public static function findById(int $id): Model|Collection|Builder|array|null
    {
        return BusinessSubCategoryChild::query()->find($id);
    }

    /**
     * Get child sub category by parent category
     *
     * @param int $businessSubCategoryId
     * @return array
     */
    public static function getChildCategory(int $businessSubCategoryId): array
    {
        $businessSubCategoryChildren = BusinessSubCategoryChild::query()
            ->whereNull("parent_id")
            ->where("business_sub_category_id", $businessSubCategoryId)
            ->get();

        $businessSubCategoryChildArray = array();
        foreach ($businessSubCategoryChildren as $businessSubCategoryChild) {
            $businessSubCategoryChildArray[] = array(
                "id" => $businessSubCategoryChild->{"id"},
                "designation" => $businessSubCategoryChild->{"designation"},
                "code" => $businessSubCategoryChild->{"code"},
                "grand_child" => self::getGrandChildCategory($businessSubCategoryChild->{"id"}),
            );
        }

        return $businessSubCategoryChildArray;
    }

    /**
     * Get grand child category by child category
     *
     * @param int $childCategoryId
     * @return Builder[]|Collection
     */
    public static function getGrandChildCategory(int $childCategoryId): Collection|array
    {
        return BusinessSubCategoryChild::query()->where("parent_id", $childCategoryId)->get();
    }
}
