<?php

namespace App\Services;

use App\Models\AttributeValue;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait AttributeValueService
{
    /**
     * Store new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return AttributeValue::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get all attribute values of attribute
     *
     * @param int $attributeId
     * @return Builder[]|Collection
     */
    public static function getValuesForAttribute(int $attributeId): Collection|array
    {
        return AttributeValue::query()->with("attributeSIUnit")->where("attribute_id", $attributeId)->get();
    }
}
