<?php

namespace App\RequestRules\Api;

class UserVerificationRules
{
    /**
     * Request validation rules
     *
     */
    public static function requestVerification(): array
    {
        $baseRules = [
            'first_name' => 'required|string|filled',
            'last_name' => 'required|string|filled',
            'date_of_birth' => ['required', 'date', 'date_format:' . config('torryme.constants.default_date_format')],
            'face_scan' => ['required', 'image', 'max:' . config('torryme.constants.max_file_size')],
            'document_type' => ['required', 'in:' . implode(",", array_values(config('torryme.document_types'))),],
        ];

        if (request()->{"document_type"} == config("torryme.document_types.cni")) {
            return array_merge(
                $baseRules,
                [
                    'cni_front' => ['required', 'image', 'max:' . config('torryme.constants.max_file_size')],
                    'cni_back' => ['required', 'image', 'max:' . config('torryme.constants.max_file_size')],
                ]
            );
        }

        if (request()->{"document_type"} == config("torryme.document_types.driver_licence")) {
            return array_merge(
                $baseRules,
                [
                    'driver_licence_front' => ['required', 'image', 'max:' . config('torryme.constants.max_file_size')],
                    'driver_licence_back' => ['required', 'image', 'max:' . config('torryme.constants.max_file_size')],
                ]
            );
        }

        if (request()->{"document_type"} == config("torryme.document_types.passport")) {
            return array_merge(
                $baseRules,
                [
                    'passport' => ['required', 'image', 'max:' . config('torryme.constants.max_file_size')],
                ]
            );
        }

        return $baseRules;
    }

}
