<?php

namespace App\RequestRules\Api;

class UserEmailRequestRule
{
   /**
    * Add rule
    *
    * @return string[]
    */
   public static function creationRules(): array
   {
      return [
         'email' => 'required|email',
         'password' => 'required|string',
      ];
   }

   /**
    * Edit rules
    *
    * @return string[]
    */
   public static function editRules(): array
   {
      return [
         'old_email' => 'required|email',
         'new_email' => 'required|email',
         'password' => 'required|string',
      ];
   }

   /**
    * Mark email as primary rules
    *
    * @return string[]
    */
   public static function markPrimaryRules(): array
   {
      return [
         'email' => 'required|email',
         'password' => 'required|string',
      ];
   }

   /**
    * Deactivate rule
    *
    * @return string[]
    */
   public static function deactivateRules(): array
   {
      return [
         'email' => 'required|email',
         'password' => 'required|string',
      ];
   }

   /**
    * Verify rules
    *
    * @return string[]
    */
   public static function verifyRules(): array
   {
      return [
         'email' => 'required|email',
         'otp' => 'required|string',
      ];
   }

   /**
    * Delete rules
    *
    * @return string[]
    */
   public static function deleteRules(): array
   {
      return [
         'email' => 'required|email',
         'password' => 'required|string',
      ];
   }
}
