<?php

namespace App\RequestRules\Api;

use App\Enums\SearchHistoryTags;

class SearchHistoryRequestRules
{

   /**
    * Search request rules
    *
    * @return string[][]
    */
   public static function search(): array
   {
      return [
         'tag' => [
            'nullable',
            'in:' . implode(",", array(
               SearchHistoryTags::products->value,
               SearchHistoryTags::services->value,
               SearchHistoryTags::users->value,
               SearchHistoryTags::live->value,
               SearchHistoryTags::hashtags->value,
            ))
         ],
         'query' => 'nullable|string',
      ];
   }

   /**
    * Delete history rule
    *
    * @return string[]
    */
   public static function delete(): array
   {
      return [
         'search_history_id' => 'sometimes|numeric|exists:search_histories,id',
      ];
   }
}
