<?php

namespace App\RequestRules\Api;

class OtpVerificationRules
{
   /**
    * Send otp code rules
    *
    * @param bool $withEmail
    * @return string[]
    */
   public static function sendOtpRules(bool $withEmail = false): array
   {
      $rules = [
         'telephone' => 'sometimes|phone:AUTO',
      ];

      if($withEmail) {
         $rules['email'] = 'sometimes|email';
      }

      return $rules;
   }

   /**
    * Checking otp code rules
    *
    * @param bool $withEmail
    * @return string[]
    */
   public static function checkingOtpRules(bool $withEmail = false): array
   {
      $rules = [
         'telephone' => 'sometimes|phone:AUTO',
         'otp' => 'required|string',
      ];

      if($withEmail) {
         $rules['email'] = 'sometimes|email';
      }

      return $rules;
   }

   /**
    * Checking 2 factors auth code
    *
    * @return string[]
    */
   public static function checking2FactorsCodeRules(): array
   {
      return [
         'email' => 'required|email',
         'otp' => 'required|string',
      ];
   }
}
