<?php

namespace App\RequestRules\Api;

class FavouriteCategoryRequestRules
{
    /**
     * Create rules
     *
     * @return string[]
     */
    public static function create(): array
    {
        return [
            'designation' => 'required|string',
        ];
    }

    /**
     * Update rules
     *
     * @return string[]
     */
    public static function update(): array
    {
        return [
            'favourite_category_id' => 'required|numeric|exists:favourite_categories,id',
            'designation' => 'required|string',
        ];
    }

    /**
     * Delete rule
     *
     * @return string[]
     */
    public static function delete(): array
    {
        return [
            'favourite_category_id' => 'required|numeric|exists:favourite_categories,id',
        ];
    }

}
