<?php

namespace App\RequestRules\Api;

class ExternalAccountRules
{

    /**
     * Configure account rules
     *
     */
    public static function configureAccount(): array
    {
        $baseRules = [
            'wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
            'payment_gateway' => ['required', 'in:' . implode(",", array_values(config('torryme.payment_gateways'))),],
            'name' => 'required|string',
            'operation_direction' => ['required', 'in:' . implode(",", array_values(config('torryme.externL_account_direction'))),],
        ];

        if (request()->{"payment_gateway"} == config("torryme.payment_gateways.momo") || request()->{"payment_gateway"} == config("torryme.payment_gateways.orange_money") || request()->{"payment_gateway"} == config("torryme.payment_gateways.eu_money")) {
            return array_merge(
                $baseRules,
                ['telephone' => 'required|string|phone:AUTO']
            );
        }

        if (request()->{"payment_gateway"} == config("torryme.payment_gateways.paypal")) {
            return array_merge(
                $baseRules,
                ['email' => 'required|string']
            );
        }

        if (request()->{"payment_gateway"} == config("torryme.payment_gateways.visa") || request()->{"payment_gateway"} == config("torryme.payment_gateways.master_card")) {
            return array_merge(
                $baseRules,
                [
                    'card_expiry_date' => ['required', 'date', 'date_format:' . config('torryme.constants.default_date_format')],
                    'card_pin' => ['required', 'string', 'min:' . config('torryme.constants.card_pin_length'), 'max:' . config('torryme.constants.card_pin_length')],
                    'card_number' => ['required', 'string', 'min:' . config('torryme.constants.card_number_length'), 'max:' . config('torryme.constants.card_number_length')],
                ]
            );
        }

        return $baseRules;
    }

    /**
     * Edit account rules
     *
     */
    public static function editAccount(): array
    {
        $baseRules = [
            'external_account_id' => 'required|numeric|exists:external_accounts,id',
            'wallet_pin' => ['required', 'string', 'min:' . config('torryme.constants.wallet_pin_length'), 'max:' . config('torryme.constants.wallet_pin_length')],
            'payment_gateway' => ['required', 'in:' . implode(",", array_values(config('torryme.payment_gateways'))),],
            'name' => 'required|string',
            'operation_direction' => ['required', 'in:' . implode(",", array_values(config('torryme.externL_account_direction'))),],
        ];

        if (request()->{"payment_gateway"} == config("torryme.payment_gateways.master_card") || request()->{"payment_gateway"} == config("torryme.payment_gateways.visa")) {
            return array_merge(
                $baseRules,
                [
                    'card_expiry_date' => ['required', 'date', 'date_format:' . config('torryme.constants.default_date_format')],
                    'card_pin' => ['required', 'string', 'min:' . config('torryme.constants.card_pin_length'), 'max:' . config('torryme.constants.card_pin_length')],
                    'card_number' => ['required', 'string', 'min:' . config('torryme.constants.card_number_length'), 'max:' . config('torryme.constants.card_number_length')],
                ]
            );
        }

        if (request()->{"payment_gateway"} == config("torryme.payment_gateways.eu_money") || request()->{"payment_gateway"} == config("torryme.payment_gateways.momo") || request()->{"payment_gateway"} == config("torryme.payment_gateways.orange_money")) {
            return array_merge(
                $baseRules,
                ['telephone' => 'required|string|phone:AUTO']
            );
        }

        if (request()->{"payment_gateway"} == config("torryme.payment_gateways.paypal")) {
            return array_merge(
                $baseRules,
                ['email' => 'required|string']
            );
        }

        return $baseRules;

    }

    /**
     * User accounts rule
     *
     * @return string[][]
     */
    public static function userAccounts(): array
    {
        return [
            'operation_direction' => ['required', 'in:' . implode(",", array_values(config('torryme.externL_account_direction'))),],
        ];
    }
}
