<?php

namespace App\RequestRules\Api;

use App\Enums\CouponDiscountTypeEnum;

class CouponRequestRules
{
    /**
     * Coupon types rule
     *
     * @return string[]
     */
    public static function getTypes(): array
    {
        return [
            'business_id' => 'nullable|numeric|exists:businesses,id',
        ];
    }

    /**
     * Create coupon rules
     *
     * @return array
     */
    public static function create(): array
    {
        $baseRules = [
            'designation' => 'required|string',
            'description' => 'nullable|string',
            'discount_type' => [
                'required',
                'in:' . implode(",", array(CouponDiscountTypeEnum::percentageDiscount->value, CouponDiscountTypeEnum::fixedCardDiscount->value, CouponDiscountTypeEnum::productDiscount->value))
            ],
            'product_discount_start_date' => ['nullable', 'date', 'date_format:' . config('torryme.constants.default_date_time_format')],
            'expiring_date' => ['required', 'date', 'date_format:' . config('torryme.constants.default_date_time_format')],
            'minimum_amount_to_spend' => 'nullable|numeric|gt:0',
            'maximum_amount_to_spend' => 'nullable|numeric|gt:0',
            'excludedProductIds' => 'sometimes|array|exists:products,id',
        ];

        if (request()->{"discount_type"} == CouponDiscountTypeEnum::percentageDiscount->value) {
            return array_merge(
                $baseRules,
                [
                    'percentage_discount' => 'required|numeric|gt:0',
                ]
            );
        }

        if (request()->{"discount_type"} == CouponDiscountTypeEnum::fixedCardDiscount->value) {
            return array_merge(
                $baseRules,
                [
                    'fixed_card_discount_amount' => 'required|numeric|gt:0',
                    'minimum_amount_to_spend' => 'required|numeric|gt:0',
                    'maximum_amount_to_spend' => 'nullable|numeric|gt:0',
                ]
            );
        }

        if (request()->{"discount_type"} == CouponDiscountTypeEnum::productDiscount->value) {
            return array_merge(
                $baseRules,
                [
                    'percentage_discount' => 'required_without:fixed_card_discount_amount|numeric|gt:0',
                    'fixed_card_discount_amount' => 'required_without:percentage_discount|numeric|gt:0',
                    'product_id' => 'required|numeric|exists:products,id',
                ]
            );
        }

        return $baseRules;
    }

}
