<?php

namespace App\RequestRules\Api;

class CityRules
{

    /**
     * Create rules
     *
     * @return string[]
     */
    public static function create(): array
    {
        return [
            'designation' => 'required|string|unique:cities,designation',
            'code' => 'required|string|unique:cities,code',
            'country_id' => 'required|numeric|exists:countries,id',
        ];
    }

    /**
     * Get cities by country rule
     *
     * @return string[]
     */
    public static function getByCountry(): array
    {
        return [
            'country_id' => 'required|numeric|exists:countries,id',
        ];
    }
}
