<?php

namespace App\RequestRules\Api;

use App\Enums\GenericStatusEnum;

class AttributeRules
{

    /**
     * Create rule
     *
     * @return string[]
     */
    public static function create(): array
    {
        return [
            'attribute_designation' => 'required|string|filled',
            'can_take_value' => [
                'required',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))],
        ];
    }
}
