<?php

namespace App\RequestRules\Api;

class AffiliateProgramRules
{

    /**
     * Create rules
     *
     * @return array
     */
    public static function create(): array
    {
        return [
            'designation' => 'required|string|filled',
            'description' => 'nullable|string',
            'percentage' => 'required|numeric|gt:0',
            'started_at' => ['required', 'date', 'date_format:' . config('torryme.constants.default_date_time_format')],
            'active_days' => 'required|numeric|gt:0',
        ];
    }

}
