<?php

namespace App\RequestRules\Api;

use App\Enums\AccountPrivacyEnum;
use App\Enums\GenericStatusEnum;

class AccountPrivacySettingRequestRules
{
    /**
     * Edit account privacy setting rules
     *
     * @return \string[][]
     */
    public static function editAccountPrivacy(): array
    {
        return [
            'enable_privacy' => [
                'sometimes',
                'in:' . implode(",", array(GenericStatusEnum::enable->value, GenericStatusEnum::disable->value))
            ],
            'who_can_comment' => [
                'sometimes',
                'in:' . implode(",", array(AccountPrivacyEnum::everyOne->value, AccountPrivacyEnum::phoneContacts->value, AccountPrivacyEnum::followers->value, AccountPrivacyEnum::noOne->value))
            ],
            'who_can_mention' => [
                'sometimes',
                'in:' . implode(",", array(AccountPrivacyEnum::everyOne->value, AccountPrivacyEnum::phoneContacts->value, AccountPrivacyEnum::followers->value, AccountPrivacyEnum::noOne->value))
            ],
            'who_can_see_follower_list' => [
                'sometimes',
                'in:' . implode(",", array(AccountPrivacyEnum::everyOne->value, AccountPrivacyEnum::phoneContacts->value, AccountPrivacyEnum::followers->value, AccountPrivacyEnum::noOne->value))
            ],
            'who_can_invite_you_by_direct_message' => [
                'sometimes',
                'in:' . implode(",", array(AccountPrivacyEnum::everyOne->value, AccountPrivacyEnum::phoneContacts->value, AccountPrivacyEnum::followers->value, AccountPrivacyEnum::noOne->value))
            ],
            'who_can_invite_you_into_community' => [
                'sometimes',
                'in:' . implode(",", array(AccountPrivacyEnum::everyOne->value, AccountPrivacyEnum::phoneContacts->value, AccountPrivacyEnum::followers->value, AccountPrivacyEnum::noOne->value))
            ],
            'who_can_download_post' => [
                'sometimes',
                'in:' . implode(",", array(AccountPrivacyEnum::everyOne->value, AccountPrivacyEnum::phoneContacts->value, AccountPrivacyEnum::followers->value, AccountPrivacyEnum::noOne->value))
            ],
        ];
    }

}
