<?php

namespace App\Providers;

use App\Events\EmailVerificationEvent;
use App\Events\TelephoneVerificationEvent;
use App\Events\TwoFactorAuthCodeEvent;
use App\Listeners\EmailVerificationListener;
use App\Listeners\TelephoneVerificationListener;
use App\Listeners\TwoFactorAuthCodeListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        TelephoneVerificationEvent::class => [
            TelephoneVerificationListener::class,
        ],
        EmailVerificationEvent::class => [
            EmailVerificationListener::class,
        ],
       TwoFactorAuthCodeEvent::class => [
          TwoFactorAuthCodeListener::class,
       ],
    ];

    /**
     * Register any events for your application.
     */
    public function boot(): void
    {
        // ...
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     */
    public function shouldDiscoverEvents(): bool
    {
        return true;
    }
}
