<?php

namespace App\Notifications;

use App\Enums\ChannelEnum;
use App\Enums\NotificationType;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use NotificationChannels\OneSignal\OneSignalChannel;
use NotificationChannels\OneSignal\OneSignalMessage;

class SendDisputeMessageNotification extends Notification implements ShouldQueue
{
   use Queueable;

   /**
    * MessageSent constructor.
    *
    * @param array $message
    */
   public function __construct(private array $message)
   {
      $this->queue = 'notification';
   }

   /**
    * Get the notification's delivery channels.
    *
    * @return string[]
    */
   public function via(): array
   {
      return [OneSignalChannel::class];
   }

   /**
    * To one signal
    *
    * @return OneSignalMessage
    */
   public function toOneSignal(): OneSignalMessage
   {
      $emitter = $this->message['emitter'];
      $labelName = ucwords($emitter->{'user'}->{'business'}?->{'designation'} ?? $emitter->{'user'}->smallName());

      return
         OneSignalMessage::create()
            ->setSubject(sprintf("Dispute - %s (%s)", $labelName, $emitter->{'user'}->{'user_name'},))
            ->setBody($this->message['message'])
            ->setData('data', array(
               'notification_type' => NotificationType::dispute->{'value'},
               'event' => ChannelEnum::sendDisputeMessageEvent->{'value'},
               'uuid' => $this->message['uuid'],
               'dispute_uuid' => $this->message['dispute_uuid'],
            ));
   }
}
