<?php

namespace App\Models;

use App\Services\WalletPinChangeHistoryService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Hash;

class WalletPinChangeHistory extends Model
{
    use HasFactory, SoftDeletes;
     use WalletPinChangeHistoryService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'wallet_pin_change_histories';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'old_wallet_pin',
        'new_wallet_pin',
        'status',

        'wallet_id',
        'user_id'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'wallet_id',
        'user_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Check wallet pin already used
     *
     * @param string $walletPin
     * @return bool
     */
    public function checkIfWalletPinAlreadyUsed(string $walletPin): bool
    {
        return Hash::check($walletPin, $this->{'new_wallet_pin'});
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */
}
