<?php

namespace App\Models;

use App\Services\WalletService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Hash;

class Wallet extends Model
{
    use HasFactory, SoftDeletes;
    use WalletService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'wallets';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'balance',
        'wallet_pin',
        'pin_attempts_left',
        'wallet_number',
        'blocked_at',

        'user_id',
        'currency_id'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'user_id',
        'currency_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['blocked_at', 'created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Check wallet pin
     *
     * @param string $walletPin
     * @return bool
     */
    public function checkWalletPin(string $walletPin): bool
    {
        return Hash::check($walletPin, $this->{'wallet_pin'});
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */

    public function currency(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Currency::class);
    }

    public function walletPinChangeHistory(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(WalletPinChangeHistory::class);
    }

    public function user(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
