<?php

namespace App\Models;

use App\Services\UserTelephoneService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserTelephone extends Model
{
   use HasFactory;
   use UserTelephoneService;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'user_telephones';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'telephone',
      'type',
      'deactivated_at',
      'verified_at',

      'user_id',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [
      'user_id',
   ];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [
      'verified_at' => 'datetime',
      'deactivated_at' => 'datetime',
   ];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at', 'deactivated_at', 'verified_at'];

   /**
    * The "booting" method of the model.
    *
    * @return void
    */
   public static function boot(): void
   {
      parent::boot();
   }

   /** Attributes used outside the class to create modify the resource */

   /** Relations */

}
