<?php

namespace App\Models;

use App\Services\UserDeviceService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserDevice extends Model
{
    use HasFactory, SoftDeletes;
    use UserDeviceService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'user_devices';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'native_device_id',
        'model',
        'brand',
        'device_name',
        'operating_system',
        'mac_address',
        'ip_address',

        'user_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'user_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

    /**
     * Creation attributes
     *
     * @return string[]
     */
    public static function creationAttributes(): array
    {
        return [
            'native_device_id',
            'model',
            'brand',
            'device_name',
            'operating_system',
            'mac_address',
            'ip_address',
        ];
    }

    /**
     * Update attributes
     *
     * @return string[]
     */
    public static function updateAttributes(): array
    {
        return [
            'model',
            'brand',
            'device_name',
            'operating_system',
            'mac_address',
            'ip_address',
        ];
    }

    /**
     * Device full name
     *
     * @return string
     */
    public function fullName(): string
    {
        return sprintf('%s %s', $this->{'device_name'}, $this->{'operating_system'});
    }

    /** Relations */
}
